#ifndef LiquidCrystal_h
#define LiquidCrystal_h
#include "module_def.h"
#include <inttypes.h>

#define DEC 10
#define HEX 16
#define OCT 8
#define BIN 2

#define BYTE 1
#define WORD 2
#define DWORD 4
#define DDWORD 8

// LCD commands
#define LCD_CLEARDISPLAY 0x01
#define LCD_RETURNHOME 0x02
#define LCD_ENTRYMODESET 0x04
#define LCD_DISPLAYCONTROL 0x08
#define LCD_CURSORSHIFT 0x10
#define LCD_FUNCTIONSET 0x20
#define LCD_SETCGRAMADDR 0x40
#define LCD_SETDDRAMADDR 0x80

// flags for display entry mode
#define LCD_ENTRYRIGHT 0x00
#define LCD_ENTRYLEFT 0x02
#define LCD_ENTRYSHIFTINCREMENT 0x01
#define LCD_ENTRYSHIFTDECREMENT 0x00

// flags for display on/off control
#define LCD_DISPLAYON 0x04
#define LCD_DISPLAYOFF 0x00
#define LCD_CURSORON 0x02
#define LCD_CURSOROFF 0x00
#define LCD_BLINKON 0x01
#define LCD_BLINKOFF 0x00

// flags for display/cursor shift
#define LCD_DISPLAYMOVE 0x08
#define LCD_CURSORMOVE 0x00
#define LCD_MOVERIGHT 0x04
#define LCD_MOVELEFT 0x00

// flags for function set
#define LCD_8BITMODE 0x10
#define LCD_4BITMODE 0x00
#define LCD_2LINE 0x08
#define LCD_1LINE 0x00
#define LCD_5x10DOTS 0x04
#define LCD_5x8DOTS 0x00


// public commande  functions 

// rw_mod if HIGH RW is used else is set to LOW
// fourbitmode if HIGH the forbit mode is set else the 8bits mode is chosen
void lcd_beginMode(uint8_t dotsize, uint8_t rw_mode , uint8_t fourbitmode);
void lcd_begin();

void lcd_clear();
void lcd_clearln(uint8_t line);
void lcd_home();
void lcd_selfTest();

void lcd_noDisplay();
void lcd_display();
void lcd_noBlink();
void lcd_blink();
void lcd_noCursor();
void lcd_cursor();
void lcd_scrollDisplayLeft();
void lcd_scrollDisplayRight();
void lcd_leftToRight();
void lcd_rightToLeft();
void lcd_autoscroll();
void lcd_noAutoscroll();

void lcd_createChar(uint8_t, uint8_t[]);
void lcd_setCursor(uint8_t col, uint8_t row);



// public printing functions 
uint8_t lcd_printStr(const char[]);		// print a string
uint8_t lcd_printChar(char);			// print a char
uint8_t lcd_printInt(int64_t, uint8_t base);	// print signed integer
uint8_t lcd_printuInt(uint64_t, uint8_t base);	// print unsigned integer
void	lcd_printBinByte(uint8_t byte);		// print byte in binary
void	lcd_printBinWord(uint16_t word);	// print word in binary
uint8_t lcd_printHex(uint64_t n, uint8_t bytes);

#endif
